Attribute VB_Name = "modFormResize"
Option Explicit

Private Type CtrlProperties
    HeightProportions   As Single
    WidthProportions    As Single
    TopProportions      As Single
    LeftProportions     As Single
End Type

Private ProportionsArray() As CtrlProperties

Public Sub InitResizeArray(ByRef Frm As Form)

    Dim I As Integer
    
    On Error Resume Next
    
    ReDim ProportionsArray(0 To Frm.Controls.Count - 1)
    
    For I = 0 To Frm.Controls.Count - 1
        With ProportionsArray(I)
            .HeightProportions = Frm.Controls(I).Height / Frm.ScaleHeight
            .WidthProportions = Frm.Controls(I).Width / Frm.ScaleWidth
            .TopProportions = Frm.Controls(I).Top / Frm.ScaleHeight
            .LeftProportions = Frm.Controls(I).Left / Frm.ScaleWidth
        End With
    Next I
    
End Sub

Public Sub ResizeControls(ByRef Frm As Form)
    '          text box                   status bar
    'Prefixes: txt (Height not adjusted); stb (Only Width adjusted)
    Dim I As Integer
        On Error Resume Next

    For I = 0 To Frm.Controls.Count - 1
        ' move and resize controls
        
        If (Left$(Frm.Controls(I).Name, 3) <> "stb") Then
            Frm.Controls(I).Left = ProportionsArray(I).LeftProportions * Frm.ScaleWidth
            Frm.Controls(I).Top = ProportionsArray(I).TopProportions * Frm.ScaleHeight
            If (Left$(Frm.Controls(I).Name, 3) <> "txt") Then
                Frm.Controls(I).Height = ProportionsArray(I).HeightProportions * Frm.ScaleHeight
            End If
        End If
        Frm.Controls(I).Width = ProportionsArray(I).WidthProportions * Frm.ScaleWidth
    Next I
End Sub
